/*
  genereaza Hot Spot9AP0 cu 
  IP 192.168.4.1
  dupa incarcare pe Oled si Serial Monitor 
  apare adresa IP 192.169.4.1
  Se dexchide pe Android Chrome
  Se introdice 192.168.4.1/webserial
  apare pagina web
  tot ce se editeaza  pe telefon apare pe Oled
  
*/

#include <Arduino.h>
#include <WiFi.h>
#include <AsyncTCP.h>
#include <ESPAsyncWebServer.h>
#include <WebSerial.h>

AsyncWebServer server(80);

const char* ssid = "ESP32-HotSpot"; 
const char* password = "12345678"; 

#include <Adafruit_SSD1306.h>
#include <Adafruit_GFX.h>
#define OLED_ADDR   0x3C
Adafruit_SSD1306 display(-1);

/* Message callback of WebSerial */
void recvMsg(uint8_t *data, size_t len){
  WebSerial.println("Received Data...");
  String d = "";
  for(int i=0; i < len; i++){
    d += char(data[i]);
    Serial.println(d);
    display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(WHITE);//trebuie
  display.setCursor(0,0);
  display.print("Primit=");
  display.print(d); //afiseaza text trimis pe oled
  display.display();
  }
  WebSerial.println(d);
}

void setup() {
    Serial.begin(115200);
    WiFi.softAP(ssid, password);

    IPAddress IP = WiFi.softAPIP();
    Serial.print("AP IP address: ");
    Serial.println(IP);
    // WebSerial is accessible at "<IP Address>/webserial" in browser
    WebSerial.begin(&server);
    /* Attach Message Callback */
    WebSerial.msgCallback(recvMsg);
    server.begin();
    display.begin(SSD1306_SWITCHCAPVCC, OLED_ADDR);
  display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(0,0);
  display.print("ESP32 webserial IP=");
  
  display.print(IP);
  display.display();
  delay(5000);
}

void loop() {
}
